<?php
require_once 'Schedule.class.php';
$TabDelimOutput = '';
$TabDelimOutputHeader = '';
$CSVDelimOutput = '';
$CSVDelimOutputHeader = '';
$isValid = false;
$errorMsg = "";
$teamCount = 0;
$teamList = [];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Schedule Generator - V 02.00.00</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/js-cookie/3.0.1/js.cookie.min.js"></script>
    <script>
        $(document).ready(function() {
            if (Cookies.get('team_list')) {
                $('#team_list').val(Cookies.get('team_list'));
            }
            if (Cookies.get('team_games')) {
                $('#team_games').val(Cookies.get('team_games'));
            }
            if (Cookies.get('teams_per_game')) {
                $('#teams_per_game').val(Cookies.get('teams_per_game'));
            }
            if (Cookies.get('game_duration_min')) {
                $('#game_duration_min').val(Cookies.get('game_duration_min'));
            }
            if (Cookies.get('game_start_datetime')) {
                $('#game_start_datetime').val(Cookies.get('game_start_datetime'));
            }
            if (Cookies.get('game_duration_between_min')) {
                $('#game_duration_between_min').val(Cookies.get('game_duration_between_min'));
            }
            
            $('#frm').submit(function() {
                Cookies.set('team_list', $('#team_list').val());
                Cookies.set('team_games', $('#team_games').val());
                Cookies.set('teams_per_game', $('#teams_per_game').val());
                Cookies.set('game_duration_min', $('#game_duration_min').val());
                Cookies.set('game_start_datetime', $('#game_start_datetime').val());
                Cookies.set('game_duration_between_min', $('#game_duration_between_min').val());
            });

            $('#game_start_datetime').dblclick(function() {
                if ($(this).val().length == 0) {
                    $(this).val(new Date().toLocaleString('en-US', { year: 'numeric', month: '2-digit', day: '2-digit', hour: '2-digit', minute: '2-digit' }));
                }
            });
        });
    </script>
</head>
<body>
    <form id="frm" method="post">
        <input type="hidden" id="act" name="act" value="gen">
        Team List (Comma Delimited.. 30 max):<br>
        <textarea rows="4" cols="80" id="team_list" name="team_list"><?= htmlspecialchars($_POST['team_list'] ?? 'Team Alpha, Team Beta, Team Omega, Team Smegma, Mung, Yeast Lovers, Intestinal Parasites, Ovarian Sistas, Kind Gore, Evangelical Imps, Scrotes') ?></textarea><br>
        Number of Games each team will play (1-30): <input id="team_games" name="team_games" value="<?= htmlspecialchars($_POST['team_games'] ?? '6') ?>"><br>
        Number of teams in each game (2-4): <input id="teams_per_game" name="teams_per_game" value="<?= htmlspecialchars($_POST['teams_per_game'] ?? '3') ?>"><br>
        Game Duration (Min): <input id="game_duration_min" name="game_duration_min" value="<?= htmlspecialchars($_POST['game_duration_min'] ?? '10') ?>"><br>
        Duration Between Games (Min): <input id="game_duration_between_min" name="game_duration_between_min" value="<?= htmlspecialchars($_POST['game_duration_between_min'] ?? '4') ?>"><br>
        Start Date/Time: <input id="game_start_datetime" name="game_start_datetime" value="<?= htmlspecialchars($_POST['game_start_datetime'] ?? '') ?>"><br>
        <input type="submit" id="submit" value="Generate the Schedule">
    </form>
<?php 
if (isset($_POST['act'])) {
    $teamList = array_map('trim', explode(',', $_POST['team_list']));
    $teamCount = count($teamList);
    if (!isValid()) {
        echo '<div align="center" style="color:red;"><strong>' . htmlspecialchars($errorMsg) . '</strong></div>';
    } else {
        $ret = GenerateSchedule($_POST['team_list'], $_POST['team_games'], $_POST['teams_per_game']);
        echo 'Generate Schedule for <b>' . $teamCount . '</b> Team(s):<br>';
        $runningGameDateTime = strtotime($_POST['game_start_datetime']);
        
        for ($iGame = 0; $iGame < count($ret); $iGame++) {
            $HTMLOutput = '&nbsp;&nbsp;&nbsp;Game ' . str_pad($iGame + 1, 3, '0', STR_PAD_LEFT);
            $TabDelimOutput .= 'Game ' . str_pad($iGame + 1, 3, '0', STR_PAD_LEFT) . "\t";
            $CSVDelimOutput .= 'Game ' . str_pad($iGame + 1, 3, '0', STR_PAD_LEFT) . ",";
            if ($iGame == 0) {
                $TabDelimOutputHeader = "Game No\tStart\tEnd\t";
                $CSVDelimOutputHeader = 'Game No,Start,End,';
            }

            $TabDelimOutput .= date('m/d/Y H:i:s', $runningGameDateTime) . "\t";
            $CSVDelimOutput .= date('m/d/Y H:i:s', $runningGameDateTime) . ",";
            $HTMLOutput .= '-&nbsp;&nbsp;Start:&nbsp;' . date('m/d/Y H:i:s', $runningGameDateTime);    
            $runningGameDateTime = strtotime('+' . $_POST['game_duration_min'] . ' minutes', $runningGameDateTime);
            $TabDelimOutput .= date('m/d/Y H:i:s', $runningGameDateTime) . "\t";
            $CSVDelimOutput .= date('m/d/Y H:i:s', $runningGameDateTime) . ",";
            $HTMLOutput .= '&nbsp;&nbsp;&nbsp;End:&nbsp;' . date('m/d/Y H:i:s', $runningGameDateTime);    
            $runningGameDateTime = strtotime('+' . $_POST['game_duration_between_min'] . ' minutes', $runningGameDateTime);
            $HTMLOutput .= '<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
            
            for ($iTeamSlot = 0; $iTeamSlot < count($ret[$iGame]); $iTeamSlot++) {
                if ($iGame == 0) {
                    $TabDelimOutputHeader .= 'Team ' . ($iTeamSlot + 1) . "\t";
                    $CSVDelimOutputHeader .= 'Team ' . ($iTeamSlot + 1) . ',';
                }
                if ($iTeamSlot > 0) $HTMLOutput .= ' vs. ';
                $HTMLOutput .= htmlspecialchars($ret[$iGame][$iTeamSlot]);

                $TabDelimOutput .= $ret[$iGame][$iTeamSlot] . "\t";
                $CSVDelimOutput .= $ret[$iGame][$iTeamSlot] . ",";
            }
            $HTMLOutput .= '<br>';
            echo $HTMLOutput;
            $TabDelimOutput .= "\n";
            $CSVDelimOutput = rtrim($CSVDelimOutput, ",") . "\n";
            if ($iGame == 0) {
                $TabDelimOutputHeader = rtrim($TabDelimOutputHeader, "\t") . "\n";
                $CSVDelimOutputHeader = rtrim($CSVDelimOutputHeader, ",") . "\n";
            }
        }
        echo '<br><br>Tab Delimited Output:<br><textarea rows="30" cols="60">' . htmlspecialchars($TabDelimOutputHeader . $TabDelimOutput) . '</textarea>';
        echo '<br><br>CSV Delimited Output:<br><textarea rows="30" cols="60">' . htmlspecialchars($CSVDelimOutputHeader . $CSVDelimOutput) . '</textarea>';
    }
}

function isValid() {
    global $errorMsg, $isValid, $teamCount;
    if ($teamCount > 30) {
        $errorMsg = 'Team Count must be 30 or less';
        return false;
    }
    if ($teamCount == 0) {
        $errorMsg = 'You gotta have teams to schedule!';
        return false;
    }
    if ($teamCount == 1) {
        $errorMsg = 'You gotta have more than 1 team to schedule!';
        return false;
    }
    if (!is_numeric($_POST['team_games'])) {
        $errorMsg = 'Number of Games each team will play must be numeric';
        return false;
    }
    if ($_POST['team_games'] > 30) {
        $errorMsg = 'Number of Games each team will play must be 30 or less';
        return false;
    }
    if ($_POST['team_games'] < 1) {
        $errorMsg = 'Number of Games must be greater than 1';
        return false;
    }
    if (!is_numeric($_POST['teams_per_game'])) {
        $errorMsg = 'Number of teams in each game must be numeric';
        return false;
    }
    if ($_POST['teams_per_game'] > 4) {
        $errorMsg = 'Number of teams in each game must be 4 or less';
        return false;
    }
    if ($_POST['teams_per_game'] < 2) {
        $errorMsg = 'You gotta have more than 1 team per game!';
        return false;
    }
    if (!is_numeric($_POST['game_duration_min'])) {
        $errorMsg = 'Game duration must be a number';
        return false;
    } elseif ($_POST['game_duration_min'] <= 0) {
        $errorMsg = 'Game duration (minutes) must be greater than zero';
        return false;
    } elseif ($_POST['game_duration_min'] > 60) {
        $errorMsg = 'Game duration (minutes) must be less than 60 minutes';
        return false;
    }
    if (!(is_numeric($_POST['game_duration_between_min']) &&
          $_POST['game_duration_between_min'] > 0 &&
          $_POST['game_duration_between_min'] < 60)) {
        $errorMsg = 'Duration between games must be a number and between 0 and 60';
        return false;
    }
    $game_start_datetime = strtotime($_POST['game_start_datetime']);
    if ($game_start_datetime === false) {
        $errorMsg = 'Invalid game start date/time';
        return false;
    }
    return true;
}
?>
    <br>
    This source code has been developed under the GPL. This means feel free to use it, alter it, etc. But you can only use it in free software. <a href="http://www.gnu.org/licenses/gpl-3.0.html">GPL 3.0 - Click here for more info</a><br>
    <a href="ScheduleGen.zip">Click here to download the Source Code</a><br>
    Any Questions, Comments, Complaints? <a href="mailto:schedulegen@noctusoft.com">Email me!</a><br>
    Enjoy!<br><br>
    &nbsp;&nbsp;Ricky Vega
</body>
</html>